class Vec2 {
	constructor(x,y){
		if(typeof x === 'string'){
			x=x.split(' ');
			this.x=parseFloat(x[0]);
			this.y=parseFloat(x[1]);
		}else if(x instanceof Vec3){
			this.x=x.x;
			this.y=x.y;
		}else if(x instanceof Vec2){
			this.x=x.x;
			this.y=x.y;
		}else if(typeof x!=='undefined'){
			this.x=x;
			this.y=(typeof y==='number')?y:x;
		}else{
			this.x=this.y=0;
		}
	}
	length(){
		return Math.sqrt(this.x*this.x+this.y*this.y);
	}
	lengthSqr(){
		return this.x*this.x+this.y*this.y;
	}
	normalize(){
		return this.divide(this.length());
	}
	copy(){
		return new Vec2(
			this.x,
			this.y
		);
	}
	add(f) {
		if(typeof f === 'number'){
			return new Vec2(
				this.x+f,
				this.y+f
			);
		}else{
			return new Vec2(
				this.x+f.x,
				this.y+f.y
			);
		}
	}
	subtract(f) {
		if(typeof f === 'number'){
			return new Vec2(
				this.x-f,
				this.y-f
			);
		}else{
			return new Vec2(
				this.x-f.x,
				this.y-f.y
			);
		}
	}
	multiply(f){
		if(typeof f === 'number'){
			return new Vec2(
				this.x*f,
				this.y*f
			);
		}else{
			return new Vec2(
				this.x*f.x,
				this.y*f.y
			);
		}
	}
	divide(f){
		if(typeof f === 'number'){
			return new Vec2(
				this.x/f,
				this.y/f
			);
		}else{
			return new Vec2(
				this.x/f.x,
				this.y/f.y
			);
		}
	}
	dot(f){
		return this.x*f.x+this.y*f.y;
	}
	reflect(f) {
		return this.subtract(f.multiply(2).multiply(this.dot(f)));
	}
	perpendicular(){
		return new Vec2(this.y, -this.x);
	}
	//smoothStep(min, max) {
	//	let x = Math.max(0, Math.min(1, (this.x-min.x)/(max.x-min.x)));
	//	let y = Math.max(0, Math.min(1, (this.y-min.y)/(max.y-min.y)));
	//	return new Vec2(x*x*(3-2*x), y*y*(3-2*y));
	//}
	toString(){
		return this.x+' '+this.y;
	}
}
class Vec3 {
	constructor(x,y,z){
		if(typeof x === 'string'){
			x=x.split(' ');
			this.x=parseFloat(x[0]);
			this.y=parseFloat(x[1]);
			this.z=parseFloat(x[2]);
		}else if(x instanceof Vec3){
			this.x=x.x;
			this.y=x.y;
			this.z=x.z;
		}else if(x instanceof Vec2){
			this.x=x.x;
			this.y=x.y;
			this.z=y||0;
		}else if(typeof x!=='undefined'){
			this.x=x;
			this.y=(typeof y==='number')?y:x;
			this.z=(typeof z==='number')?z:((typeof y==='number')?0:x);
		}else{
			this.x=this.y=this.z=0;
		}
	}
	length(){
		return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z);
	}
	lengthSqr(){
		return this.x*this.x+this.y*this.y+this.z*this.z;
	}
	normalize(){
		return this.divide(this.length());
	}
	copy(){
		return new Vec3(
			this.x,
			this.y,
			this.z
		);
	}
	add(f) {
		if(typeof f === 'number'){
			return new Vec3(
				this.x+f,
				this.y+f,
				this.z+f
			);
		}else{
			return new Vec3(
				this.x+f.x,
				this.y+f.y,
				this.z+f.z
			);
		}
	}
	subtract(f) {
		if(typeof f === 'number'){
			return new Vec3(
				this.x-f,
				this.y-f,
				this.z-f
			);
		}else{
			return new Vec3(
				this.x-f.x,
				this.y-f.y,
				this.z-f.z
			);
		}
	}
	multiply(f){
		if(typeof f === 'number'){
			return new Vec3(
				this.x*f,
				this.y*f,
				this.z*f
			);
		}else{
			return new Vec3(
				this.x*f.x,
				this.y*f.y,
				this.z*f.z
			);
		}
	}
	divide(f){
		if(typeof f === 'number'){
			return new Vec3(
				this.x/f,
				this.y/f,
				this.z/f
			);
		}else{
			return new Vec3(
				this.x/f.x,
				this.y/f.y,
				this.z/f.z
			);
		}
	}
	cross(f){
		return new Vec3(
			this.y*f.z-this.z*f.y,
			this.z*f.x-this.x*f.z,
			this.x*f.y-this.y*f.x
		);
	}
	dot(f){
		return this.x*f.x+this.y*f.y+this.z*f.z;
	}
	reflect(f) {
		return this.subtract(f.multiply(2).multiply(this.dot(f)));
	}
	//smoothStep(min, max) {
	//	let x = Math.max(0, Math.min(1, (this.x-min.x)/(max.x-min.x)));
	//	let y = Math.max(0, Math.min(1, (this.y-min.y)/(max.y-min.y)));
	//	let z = Math.max(0, Math.min(1, (this.z-min.z)/(max.z-min.z)));
	//	return new Vec3(x*x*(3-2*x), y*y*(3-2*y), z*z*(3-2*z));
	//}
	toString(){
		return this.x+' '+this.y+' '+this.z;
	}
}
this._Vec2 = Vec2.prototype;
this._Vec3 = Vec3.prototype;
this._Internal = {
	convertUserProperties(p) {
		p = JSON.parse(p);
		let r = {};
		for (var k in p) {
			r[k] = p[k].value;
			switch (p[k].type){
			case 'color':
				r[k] = new Vec3(r[k]);
				break;
			}
		}
		return r;
	}
};
this.shared = {};